/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.api.VWIndexDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class VWIndexListRenderer
extends DefaultListCellRenderer
implements TableCellRenderer {
    protected static final Border BORDER_NO_FOCUS = new EmptyBorder(1, 1, 1, 1);
    protected static final Border BORDER_INSETS = new EmptyBorder(new Insets(5, 5, 5, 5));

    public VWIndexListRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int nIndex, boolean bIsSelected, boolean bCellHasFocus) {
        try {
            ComponentOrientation o = ComponentOrientation.getOrientation(Locale.getDefault());
            this.setComponentOrientation(o);
            if (bIsSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.updateText(value);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ComponentOrientation o = ComponentOrientation.getOrientation(Locale.getDefault());
        this.setComponentOrientation(o);
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(new CompoundBorder(border, BORDER_INSETS));
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    this.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    this.setBackground(col);
                }
            }
        } else {
            this.setBorder(new CompoundBorder(BORDER_NO_FOCUS, BORDER_INSETS));
        }
        this.updateText(value);
        return this;
    }

    private void updateText(Object value) {
        if (value != null) {
            if (value instanceof VWIndexDefinition) {
                String indexName = this.getIndexName((VWIndexDefinition)value);
                this.setText(indexName);
                this.setToolTipText(indexName);
            } else {
                this.setText(value.toString());
                this.setToolTipText(null);
            }
        } else {
            this.setText(VWResource.s_selectAnIndex);
            this.setToolTipText(null);
        }
    }

    private String getIndexName(VWIndexDefinition indexDef) {
        try {
            StringBuffer buffer = new StringBuffer(indexDef.getName());
            String[] fieldNames = indexDef.getFieldNames();
            if (fieldNames != null && fieldNames.length > 0) {
                buffer.append(" (");
                for (int nIndex = 0; nIndex < fieldNames.length; ++nIndex) {
                    if (nIndex > 0) {
                        buffer.append(" + ");
                    }
                    buffer.append(fieldNames[nIndex]);
                }
                buffer.append(")");
            }
            return buffer.toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return indexDef.getName();
        }
    }
}

